<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Flex
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace MagicLogin\Dependencies\Twilio\Rest\FlexApi\V1\Interaction\InteractionChannel;

use MagicLogin\Dependencies\Twilio\Exceptions\TwilioException;
use MagicLogin\Dependencies\Twilio\Values;
use MagicLogin\Dependencies\Twilio\Version;
use MagicLogin\Dependencies\Twilio\InstanceContext;


class InteractionTransferContext extends InstanceContext
    {
    /**
     * Initialize the InteractionTransferContext
     *
     * @param Version $version Version that contains the resource
     * @param string $interactionSid The Interaction Sid for the Interaction
     * @param string $channelSid The Channel Sid for the Channel.
     * @param string $sid The unique string created by MagicLogin\Dependencies\Twilio to identify a Transfer resource.
     */
    public function __construct(
        Version $version,
        $interactionSid,
        $channelSid,
        $sid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'interactionSid' =>
            $interactionSid,
        'channelSid' =>
            $channelSid,
        'sid' =>
            $sid,
        ];

        $this->uri = '/Interactions/' . \rawurlencode($interactionSid)
        .'/Channels/' . \rawurlencode($channelSid)
        .'/Transfers/' . \rawurlencode($sid)
        .'';
    }

    /**
     * Fetch the InteractionTransferInstance
     *
     * @return InteractionTransferInstance Fetched InteractionTransferInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): InteractionTransferInstance
    {

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        $payload = $this->version->fetch('GET', $this->uri, [], [], $headers);

        return new InteractionTransferInstance(
            $this->version,
            $payload,
            $this->solution['interactionSid'],
            $this->solution['channelSid'],
            $this->solution['sid']
        );
    }


    /**
     * Update the InteractionTransferInstance
     *
     * @return InteractionTransferInstance Updated InteractionTransferInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(): InteractionTransferInstance
    {

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        $data = $body->toArray();
        $headers['Content-Type'] = 'application/json';
        $payload = $this->version->update('POST', $this->uri, [], $data, $headers);

        return new InteractionTransferInstance(
            $this->version,
            $payload,
            $this->solution['interactionSid'],
            $this->solution['channelSid'],
            $this->solution['sid']
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.FlexApi.V1.InteractionTransferContext ' . \implode(' ', $context) . ']';
    }
}
