<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Routes
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MagicLogin\Dependencies\Twilio\Rest\Routes;

use MagicLogin\Dependencies\Twilio\Domain;
use MagicLogin\Dependencies\Twilio\Exceptions\TwilioException;
use MagicLogin\Dependencies\Twilio\InstanceContext;
use MagicLogin\Dependencies\Twilio\Rest\Routes\V2\PhoneNumberList;
use MagicLogin\Dependencies\Twilio\Rest\Routes\V2\SipDomainList;
use MagicLogin\Dependencies\Twilio\Rest\Routes\V2\TrunkList;
use MagicLogin\Dependencies\Twilio\Version;

/**
 * @property PhoneNumberList $phoneNumbers
 * @property SipDomainList $sipDomains
 * @property TrunkList $trunks
 * @method \MagicLogin\Dependencies\Twilio\Rest\Routes\V2\PhoneNumberContext phoneNumbers(string $phoneNumber)
 * @method \MagicLogin\Dependencies\Twilio\Rest\Routes\V2\SipDomainContext sipDomains(string $sipDomain)
 * @method \MagicLogin\Dependencies\Twilio\Rest\Routes\V2\TrunkContext trunks(string $sipTrunkDomain)
 */
class V2 extends Version
{
    protected $_phoneNumbers;
    protected $_sipDomains;
    protected $_trunks;

    /**
     * Construct the V2 version of Routes
     *
     * @param Domain $domain Domain that contains the version
     */
    public function __construct(Domain $domain)
    {
        parent::__construct($domain);
        $this->version = 'v2';
    }

    protected function getPhoneNumbers(): PhoneNumberList
    {
        if (!$this->_phoneNumbers) {
            $this->_phoneNumbers = new PhoneNumberList($this);
        }
        return $this->_phoneNumbers;
    }

    protected function getSipDomains(): SipDomainList
    {
        if (!$this->_sipDomains) {
            $this->_sipDomains = new SipDomainList($this);
        }
        return $this->_sipDomains;
    }

    protected function getTrunks(): TrunkList
    {
        if (!$this->_trunks) {
            $this->_trunks = new TrunkList($this);
        }
        return $this->_trunks;
    }

    /**
     * Magic getter to lazy load root resources
     *
     * @param string $name Resource to return
     * @return \MagicLogin\Dependencies\Twilio\ListResource The requested resource
     * @throws TwilioException For unknown resource
     */
    public function __get(string $name)
    {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown resource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments): InstanceContext
    {
        $property = $this->$name;
        if (\method_exists($property, 'getContext')) {
            return \call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Routes.V2]';
    }
}
